Scriptname SuC_MCM extends SKI_ConfigBase

Actor Property PlayerAlias auto
Actor Property PlayerRef Auto
Actor Property SuC_pet_dog Auto

GlobalVariable Property SuC_stat_pc_level auto
GlobalVariable Property SuC_stat_pc_xp auto
GlobalVariable Property SuC_stat_dog_level auto
GlobalVariable Property SuC_stat_dog_xp auto
GlobalVariable Property SuC_stat_rabbit_level auto
GlobalVariable Property SuC_stat_rabbit_xp auto
GlobalVariable Property SuC_unlock_dog auto
GlobalVariable Property SuC_unlock_rabbit auto

Spell Property SuC_sum_dog auto
Spell Property SuC_spell_dograpetarget auto

;Pet Status
int status_pclevel
int status_pcnext
int status_doglevel
int status_dognext
int status_rabbitlevel
int status_rabbitnext
int status_unlockdog
int status_unlockdogr
int status_doghealth
int status_dogstamina
int status_doglove
int status_doglike
int status_rabbithealth
int status_rabbitstamina
int status_rabbitlove

;Trainer Unlocks
int unlocks_dog
int unlocks_rabbit

;Settings / Help


;ent/ Init
Event OnConfigInit()
	ModName = "Soul Pets"
	Pages = new string[3]
		Pages[0] = "Pet Status"
		Pages[1] = "Trainer Unlocks"
		Pages[2] = "Settings / Help"
endEvent
;end/

;ent/ MCMupdate
Function MCMupdate()
	
endFunction
;end/

;ent/ OnPageReset
Event OnPageReset(string page)
	;ent/ Initial Page
	if(page == "")
		return
	else
		UnloadCustomContent()
	endIf
	;end/
	;ent/ Pet Status
	if(page == "Pet Status")
		int trainerlevel = SuC_stat_pc_level.GetValue() as int
		int trainerxp = SuC_stat_pc_xp.GetValue() as int
		int trainernext = Math.Floor((trainerlevel*2.8) * 50 + 20)
		int doglevel = SuC_stat_dog_level.GetValue() as int
		int dogxp = SuC_stat_dog_xp.GetValue() as int
		int dognext = Math.Floor((doglevel*1.4) * 40 + 10)
		int doghealth = Math.Floor(doglevel*11 + 10)
		int dogstamina = Math.Floor(doglevel*4 + 20)
		int rabbitlevel = SuC_stat_rabbit_level.GetValue() as int
		int rabbitxp = SuC_stat_rabbit_xp.GetValue() as int
		int rabbitnext = Math.Floor((rabbitlevel*1.4) * 44 + 20)
		int rabbithealth = Math.Floor(rabbitlevel*11 + 10)
		int rabbitstamina = Math.Floor(rabbitlevel*4 + 20)
		
		SetCursorFillMode(LEFT_TO_RIGHT)
		SetCursorPosition(0)
		status_pclevel = AddTextOption("Trainer Level ", trainerlevel)
		status_pcnext = AddTextOption("Level progress...", trainerxp+"/"+trainernext+" XP")
		
		AddEmptyOption()
		AddEmptyOption()
		
		status_doglevel = AddTextOption("Skylo [Dog Soul] Level ", doglevel)
		status_dognext = AddTextOption("Level progress... ", dogxp+"/"+dognext+" XP")
		
		;status_doghealth = AddTextOption("Bonus Health +"+doghealth, " ")
		;status_dogstamina = AddTextOption("Bonus Stamina +"+dogstamina, " ")
		
		if doglevel > 4 ;5
			status_doglove = AddTextOption("Loves being victim", " ")
		else
			status_doglove = AddTextOption("Loves ??? [Skylo Level "+doglevel+"/5] ", " ")
		endIf
		if doglevel > 1 ;2
			status_doglike = AddTextOption("Likes being with trainer", " ")
		else
			status_doglike = AddTextOption("Likes ??? [Skylo Level "+doglevel+"/2] ", " ")
		endIf
		
		AddEmptyOption()
		AddEmptyOption()
		
		if SuC_unlock_rabbit.GetValue()
			status_rabbitlevel = AddTextOption("Koune [Rabbit Soul] Level ", rabbitlevel)
			status_rabbitnext = AddTextOption("Level progress... ", rabbitxp+"/"+rabbitnext+" XP")
		
			;status_rabbithealth = AddTextOption("Bonus Health +"+rabbithealth, " ")
			;status_rabbitstamina = AddTextOption("Bonus Stamina +"+rabbitstamina, " ")
			
			if rabbitlevel > 2 ;3
				status_rabbitlove = AddTextOption("Loves being aggressor", " ")
			else
				status_rabbitlove = AddTextOption("Loves ??? [Koune Level "+rabbitlevel+"/3]", " ")
			endIf
		endIf
		
	;end/
	elseIf(page == "Trainer Unlocks")
		
		int dogunlocks = 0
		int doglevel = SuC_stat_dog_level.GetValue() as int
		if doglevel > 4 ;5
			dogunlocks = 3
		elseif doglevel > 1 ;2
			dogunlocks = 2
		elseif SuC_unlock_dog.GetValue()
			dogunlocks = 1
		endIf
		
		int rabbitunlocks = 0
		int rabbitlevel = SuC_stat_dog_level.GetValue() as int
		if rabbitlevel > 2 ;3
			rabbitunlocks = 2
		elseIf SuC_unlock_rabbit.GetValue()
			rabbitunlocks = 1
		endIf
		
		SetCursorFillMode(TOP_TO_BOTTOM)
		
		;Left Side
		SetCursorPosition(0)
		AddHeaderOption("Available Unlocks")
		AddEmptyOption()
		
		AddHeaderOption("Unlocks Achieved")
		unlocks_dog = AddTextOption("Skylo [Dog Soul] ", dogunlocks+"/3")
		unlocks_rabbit = AddTextOption("Koune [Rabbit Soul] ", rabbitunlocks+"/2")
		
		;Right Side
		SetCursorPosition(1)
		
		AddHeaderOption("Statistics")
		
	elseIf(page == "Settings / Help")
	
	endIf
endEvent
;end/
;ent/ OnOptionSelect
Event OnOptionSelect(int option)
EndEvent
;end/
;ent/ OnOptionHighlight
Event OnOptionHighlight(int option)
	;ent/ Pet Status
	if(CurrentPage == "Pet Status")
		if(option == status_pclevel)
			SetInfoText("Current Trainer Level. [Unlocks new pets and spells]")
		elseif(option == status_pcnext)
			SetInfoText("XP toward a Trainer level up.")
		endIf
	endIf
	;end/
endEvent
;end/